/*
 
 This program provides several examples 
 of correct pointer operations:
   a = *p2;
   copy value pointed to by p2 to a
 
   *p1 = 35;
   set value of variable pointed to by p1 to 35
 
   *p1 = b;
   copy value of b to value pointed to by p1
 
   *p1 = *p2;
   copy value pointed to by p2 to value pointed to by p1
 
   p1 = & b;
   p1 gets the address of b
 
   p1 = p2;
   p1 gets the address stored in p2 (i.e., they now 
      point to the same location)
 
*/
#include <stdio.h>

int main(void)
{
   int a, b, *p1, *p2;
   a = 30;
   b = 50;
   p1 = &a;
   p2 = &b;

   printf("%d %d %d %d %p %p\n", a, b, *p1, *p2, p1, p2);

   a = *p2;
   printf("%d %d %d %d %p %p\n", a, b, *p1, *p2, p1, p2);

   *p1 = 35;
   printf("%d %d %d %d %p %p\n", a, b, *p1, *p2, p1, p2);

   *p1 = b;
   printf("%d %d %d %d %p %p\n", a, b, *p1, *p2, p1, p2);

   *p1 = *p2;
   printf("%d %d %d %d %p %p\n", a, b, *p1, *p2, p1, p2);
 
   p1 = &b;
   printf("%d %d %d %d %p %p\n", a, b, *p1, *p2, p1, p2);

   p1 = p2;
   printf("%d %d %d %d %p %p\n", a, b, *p1, *p2, p1, p2);

   return 0;
}
